

--CC_CONTENT_SCALE_FACTOR = function()
--    return cc.Director:getInstance():getContentScaleFactor()
--end
--
--
--CC_POINT_PIXELS_TO_POINTS = function(pixels)
--    return cc.p(pixels.x/CC_CONTENT_SCALE_FACTOR(), pixels.y/CC_CONTENT_SCALE_FACTOR())
--end
--
--CC_POINT_POINTS_TO_PIXELS = function(points)
--    return cc.p(points.x*CC_CONTENT_SCALE_FACTOR(), points.y*CC_CONTENT_SCALE_FACTOR())
--end
--
--function DEGREES_TO_RADIANS(__ANGLE__) 
--    return __ANGLE__ * 0.01745329252
--end
--function RADIANS_TO_DEGREES(__ANGLE__)
--    return __ANGLE__ * 57.29577951
--end

-- require "Water_Data"

DirectorUtils={}

--是否是iphone4
function DirectorUtils.isDeviceFour()
    local frameSize=cc.Director:getInstance():getOpenGLView():getFrameSize()
    
    if frameSize.width==640 and frameSize.height==960 then
    	return true
    end
    
    return false
end

function DirectorUtils.getLinePosY(row,height)

    local Y = (row-1)*height+(row-1)*LINE_INTERVAL+height*0.5
    return Y
end

--动画
function DirectorUtils.GameAnimate(type,isROF,isRF,delay)
--    local str=name.."_"..type
    local str="BlockGirl_animate"

    if type==Block_Square then
        str="Block_Square_animate"

   elseif type==Block_Small_Triangle then 
        str="Block_Small_Triangle_animate"

   elseif type==Block_Parallelogram then
        str="Block_Parallelogram_animate"

   elseif type==Block_Big_Triangle then
        str="Block_Big_Triangle_animate"
    elseif type=="guangqiu1" then
        str="guangqiu1_animate"
   end

   print("type===",type)
   print("str===",str)
    -- local cannonAnimation=cc.AnimationCache:getInstance():getAnimation(str)
    -- local cannonAnimate=cc.Animate:create(cannonAnimation);
    local blockAnimation=cc.AnimationCache:getInstance():getAnimation(str)
    blockAnimation:setDelayPerUnit(delay);
    blockAnimation:setRestoreOriginalFrame(isROF);
    local blockAnimate=cc.Animate:create(blockAnimation);
    
    if isRF then
        local RFAction=cc.RepeatForever:create(blockAnimate)
        return RFAction
    else 
        return blockAnimate
    end
end

--动画
function DirectorUtils.GameAnimatePng(type)
   local str="BlockGirl_1.png"

   if type==BlockTypeEnum.Block_Square then
        str="Block_Square_1.png"

   elseif type==BlockTypeEnum.Block_Small_Triangle then 
        str="Block_Small_Triangle_1.png"

   elseif type==BlockTypeEnum.Block_Parallelogram then
        str="Block_Parallelogram_1.png"

   elseif type==BlockTypeEnum.Block_Big_Triangle then
        str="Block_Big_Triangle_1.png"
   end

   return str
end


--游戏坐标转网格RC坐标
function DirectorUtils.getGameGridRC(x,y)
    x=x-GRIDPOINT_X
    y=y-GRIDPOINT_Y

    --print("x==",x)
    --print("y==",y)

    if x<GRIDPOINT_X then
        --todo
        x=GRIDPOINT_X
    elseif x>display.size.width-GRIDPOINT_X-GRIDWIDTH/2 then
            --todo    
         x=display.size.width-GRIDPOINT_X-GRIDWIDTH/2
    end

    if y<GRIDPOINT_Y then
        --todo
        y=GRIDPOINT_Y
    elseif y>display.size.height-GRIDPOINT_Y-GRIDWIDTH/2 then
            --todo    
        y=display.size.height-GRIDPOINT_Y-GRIDWIDTH/2
    end

    --print("---------------")
    --print("x==",x)
    --print("y==",y)

    local R=math.floor(x/GRIDWIDTH)+1
    local C=math.floor(y/GRIDWIDTH)+1

    return R,C
end

--游戏坐标转网格中点坐标
function DirectorUtils.getGameGridPoint(R,C)

    local pointX=R*GRIDWIDTH
    local pointY=C*GRIDWIDTH

    local point=cc.p(pointX-GRIDWIDTH/2+GRIDPOINT_X,pointY-GRIDWIDTH/2+GRIDPOINT_Y)
    return point
end


--游戏小女孩起始网格坐标 终点坐标
function DirectorUtils.getGameShowGirlGridPoint(R,C)

    local pointX=R*GRIDWIDTH
    local pointY=C*GRIDWIDTH

    local point=cc.p(pointX+GRIDPOINT_X,pointY+GRIDPOINT_Y)
    return point
end

--描绘正方形格子
function DirectorUtils.drawFullLattice(draw,point)

    local addWidht=GRIDWIDTH/2
    local star2 = {
        cc.p(point.x-addWidht, point.y-addWidht), cc.p(point.x+addWidht, point.y-addWidht),   
        cc.p(point.x+addWidht, point.y+addWidht), cc.p(point.x-addWidht, point.y+addWidht),                                      
    };
        
    draw:drawPolygon(star2, #(star2), cc.c4f(1,0,0,0.5), 1, cc.c4f(0,0,1,1))
end

-- Semi_Lattice_Left_Up=2,
--     Semi_Lattice_Left_Down=3,
--     Semi_Lattice_Right_Up=4,   
--     Semi_Lattice_Right_Down=5,    

--描绘左三角形上
function DirectorUtils.drawSemiLatticeLeftUp(draw,point)
    print("drawSemiLatticeLeftUpdrawSemiLatticeLeftUp")
    local addWidht=GRIDWIDTH/2
    local star2 = {
        cc.p(point.x-addWidht, point.y-addWidht), cc.p(point.x+addWidht, point.y+addWidht),   
        cc.p(point.x+addWidht, point.y-addWidht),                                      
    };
        
    draw:drawPolygon(star2, #(star2), cc.c4f(1,0,0,0.5), 1, cc.c4f(0,0,1,1))
end

--描绘左三角形下
function DirectorUtils.drawSemiLatticeLeftDown(draw,point)
    local addWidht=GRIDWIDTH/2
    local star2 = {
        cc.p(point.x-addWidht, point.y-addWidht), cc.p(point.x+addWidht, point.y+addWidht),   
        cc.p(point.x+addWidht, point.y-addWidht),                                      
    };
        
    draw:drawPolygon(star2, #(star2), cc.c4f(1,0,0,0.5), 1, cc.c4f(0,0,1,1))
end


--描绘右三角形上
function DirectorUtils.drawSemiLatticeRightUp(draw,point)

    local addWidht=GRIDWIDTH/2
    local star2 = {
        cc.p(point.x-addWidht, point.y-addWidht), cc.p(point.x+addWidht, point.y+addWidht),   
        cc.p(point.x+addWidht, point.y-addWidht),                                      
    };
        
    draw:drawPolygon(star2, #(star2), cc.c4f(1,0,0,0.5), 1, cc.c4f(0,0,1,1))
end

--描绘右三角形下
function DirectorUtils.drawSemiLatticeRightDown(draw,point)
    local addWidht=GRIDWIDTH/2
    local star2 = {
        cc.p(point.x-addWidht, point.y-addWidht), cc.p(point.x+addWidht, point.y+addWidht),   
        cc.p(point.x+addWidht, point.y-addWidht),                                      
    };
        
    draw:drawPolygon(star2, #(star2), cc.c4f(1,0,0,0.5), 1, cc.c4f(0,0,1,1))
end

function DirectorUtils.getGridInfoTable(x,y,info)
    local gridInfoTable={}
    gridInfoTable["r"]=x
    gridInfoTable["c"]=y
    gridInfoTable["info"]=info
    return gridInfoTable
end    

--获取单个网格地形的顶点坐标
function DirectorUtils.getGridWithTypePoint(r,c,type,isRight)
    local gridPosition=DirectorUtils.getGameGridPoint(r,c)

    local pointTable=nil
    if type==GridTypeEnum.Full_Lattice then
        --todo
        pointTable=DirectorUtils.getFullLatticeVertexPoint(gridPosition,isRight)

    elseif type==GridTypeEnum.Semi_Lattice_Left_Up then
        --todo
        pointTable=DirectorUtils.getSemiLatticeLeftUpVertexPoint(gridPosition,isRight)
    elseif type==GridTypeEnum.Semi_Lattice_Left_Down then

        pointTable=DirectorUtils.getSemiLatticeLeftDownVertexPoint(gridPosition,isRight)

    elseif type==GridTypeEnum.Semi_Lattice_Right_Up then

        pointTable=DirectorUtils.getSemiLatticeRightUpVertexPoint(gridPosition,isRight)

    else 

        pointTable=DirectorUtils.getSemiLatticeRightDownVertexPoint(gridPosition,isRight)
    end

    return pointTable
end


--格子坐标
--正方形四个顶点坐标 
--有左右四种形态
--参数方块的坐标
--         左           
--        B---A
--        |   |
--        |   |
--        C---D

--         右           
--        A---B
--        |   |
--        |   |
--        D---C

function DirectorUtils.getFullLatticeVertexPoint(point,isRight)

    local addWidht=GRIDWIDTH/2
    local vPoint

    if isRight==true then
        --todo
        --右边顶点坐标
        vPoint = {
            A=cc.p(point.x-addWidht, point.y+addWidht), 
            B=cc.p(point.x+addWidht, point.y+addWidht),   
            C=cc.p(point.x+addWidht, point.y-addWidht), 
            D=cc.p(point.x-addWidht, point.y-addWidht),                                    
        }  
    else
        --左边顶点坐标
        vPoint = {
            A=cc.p(point.x+addWidht, point.y+addWidht), 
            B=cc.p(point.x-addWidht, point.y+addWidht),   
            C=cc.p(point.x-addWidht, point.y-addWidht), 
            D=cc.p(point.x+addWidht, point.y-addWidht),                                        
        }   
    end
    return vPoint
end

--左三角形上三个顶点坐标 
--        左
--        B
--        | \   
--        |  \  
--        C---A

--        右
--        A
--        | \   
--        |  \  
--        C---B

function DirectorUtils.getSemiLatticeLeftUpVertexPoint(point,isRight)

    local addWidht=GRIDWIDTH/2
    local vPoint

    if isRight==true then
        --todo
        --右边顶点坐标
        vPoint = {
            A=cc.p(point.x-addWidht, point.y+addWidht), 
            B=cc.p(point.x+addWidht, point.y-addWidht),   
            C=cc.p(point.x-addWidht, point.y-addWidht),                                         
        }
    else
        --左边顶点坐标
        vPoint = {
            A=cc.p(point.x+addWidht, point.y-addWidht), 
            B=cc.p(point.x-addWidht, point.y+addWidht),   
            C=cc.p(point.x-addWidht, point.y-addWidht),                                   
        } 
    end

    return vPoint
        
end

--左三角形下三个顶点坐标
--        左 
--        B---A
--        |  / 
--        | /   
--        C

--        右 
--        A---B
--        |  / 
--        | /   
--        C

function DirectorUtils.getSemiLatticeLeftDownVertexPoint(point,isRight)
    local addWidht=GRIDWIDTH/2
    local vPoint

    if isRight==true then
        --todo
        --右边顶点坐标
        vPoint = {
            A=cc.p(point.x-addWidht, point.y+addWidht), 
            B=cc.p(point.x+addWidht, point.y+addWidht),
            C=cc.p(point.x-addWidht, point.y-addWidht),                                          
        }
    else
        --左边顶点坐标
        vPoint = {
            A=cc.p(point.x+addWidht, point.y+addWidht), 
            B=cc.p(point.x-addWidht, point.y+addWidht),   
            C=cc.p(point.x-addWidht, point.y-addWidht),                                  
        } 
    end

    return vPoint
end


--右三角形上三个顶点坐标 
--           左 
--            A
--          / |
--         /  |
--        B---C

--           右
--            B
--          / |
--         /  |
--        A---C

function DirectorUtils.getSemiLatticeRightUpVertexPoint(point,isRight)

    local addWidht=GRIDWIDTH/2
    local vPoint

    if isRight==true then
        --todo
        --右边顶点坐标
        vPoint = {
            A=cc.p(point.x-addWidht, point.y-addWidht), 
            B=cc.p(point.x+addWidht, point.y+addWidht),
            C=cc.p(point.x+addWidht, point.y-addWidht),                                          
        }
    else
        --左边顶点坐标
        vPoint = {
            A=cc.p(point.x+addWidht, point.y+addWidht), 
            B=cc.p(point.x-addWidht, point.y-addWidht),   
            C=cc.p(point.x+addWidht, point.y-addWidht),                                  
        } 
    end

    return vPoint

end

--描绘右三角形下三个顶点坐标 
--           左
--        B---A
--         \  |
--          \ |
--           C

--           右
--        A---B
--         \  |
--          \ |
--           C
function DirectorUtils.getSemiLatticeRightDownVertexPoint(point,isRight)
    local addWidht=GRIDWIDTH/2
    local vPoint

    if isRight==true then
        --右边顶点坐标
        vPoint = {
            A=cc.p(point.x-addWidht, point.y+addWidht), 
            B=cc.p(point.x+addWidht, point.y+addWidht),
            C=cc.p(point.x+addWidht, point.y-addWidht),                                          
        }
    else
        --左边顶点坐标
        vPoint = {
            A=cc.p(point.x+addWidht, point.y+addWidht), 
            B=cc.p(point.x-addWidht, point.y+addWidht),   
            C=cc.p(point.x+addWidht, point.y-addWidht),                                  
        } 
    end
    return vPoint        
end

--方块底部的坐标
function DirectorUtils.getBlockBottomPoint(block)

    if block.BlockType==BlockTypeEnum.Block_Square 
        or block.BlockType==BlockTypeEnum.Block_Small_Triangle then
        --todo
        local bbPos=getPosTable(block)
        local pos=cc.p(bbPos.x,bbPos.y-GRIDWIDTH/2)
        return pos
    else
        if block.blockRotation==0 or block.blockRotation==180 then
            --todo
            local bbPos=getPosTable(block)
            local pos=cc.p(bbPos.x,bbPos.y-GRIDWIDTH/2)
            return pos 
        else
            local bbPos=getPosTable(block)
            local pos=cc.p(bbPos.x,bbPos.y-GRIDWIDTH)
            return pos 
        end
    end

end    


function DirectorUtils.getGameBlock(data)

    local block=nil
    if data.BlockType==BlockTypeEnum.Block_Parallelogram then
        block=require("LParallelogram").create(data)
    elseif data.BlockType==BlockTypeEnum.Block_Square then

        if data.material and data.material=="crab" then
            print("data.material=====",data.material)
            block=require("LCrabBlock").create(data)
        elseif data.material and data.material=="octopus" then
            --todo
            block=require("LOctopusBlock").create(data)
        elseif data.material and data.material=="echinus" then
            --todo
            block=require("LEchinusBlock").create(data)    
        else
            block=require("LSquare").create(data)        
        end
        
    elseif data.BlockType==BlockTypeEnum.Block_Big_Triangle then
        block=require("LBigTriangle").create(data)
    elseif data.BlockType==BlockTypeEnum.Block_Small_Triangle then
        block=require("LSmallTriangle").create(data)
    end
    return block
end    

function DirectorUtils.setGameBlockGridTable(blockTable,r,c)
    print("setGameBlockGridTable")
    print("r=====",r)
    print("c=====",c)

    if RoadGridTable[r] then
        --todo
        if RoadGridTable[r][c] then
            --todo
            local t={}
            for i,v in ipairs(blockTable) do
                t[i]=v
                print("i...............",i)
            end
            RoadGridTable[r][c].GridSprite=t
        end
    end
end   

function DirectorUtils.getGameBlockGridTable(r,c)
    if RoadGridTable[r] then
        --todo
        if RoadGridTable[r][c] then
            --todo
            if RoadGridTable[r][c].GridSprite then
                --todo
                return RoadGridTable[r][c].GridSprite
            end
        end
    end
    --没有返回空
    return nil
end   

--拆开整格的方块 不能传Full_Lattice参数
function DirectorUtils.getFullBlockSeparate(type)

    if type==GridTypeEnum.Semi_Lattice_Left_Up then
        --todo
        return GridTypeEnum.Semi_Lattice_Right_Down
    elseif type==GridTypeEnum.Semi_Lattice_Right_Up then
        --todo
        return GridTypeEnum.Semi_Lattice_Left_Down
    elseif type==GridTypeEnum.Semi_Lattice_Right_Down then
        --todo
        return GridTypeEnum.Semi_Lattice_Left_Up
    else
        --todo
        return GridTypeEnum.Semi_Lattice_Right_Up
    end

end   


--去方块在网格的精灵索引 类型从上到下
function DirectorUtils.getFullBlockGridSpriteKey(type)

    if type==GridTypeEnum.Semi_Lattice_Left_Up then
        --todo
        return 2
    elseif type==GridTypeEnum.Semi_Lattice_Right_Up then
        --todo
        return 2
    elseif type==GridTypeEnum.Semi_Lattice_Right_Down then
        --todo
        return 1
    else
        --todo
        return 1
    end

end   

function DirectorUtils.removeFormRoadGrid(block)

    local rcTable=block.rc
    print("rcTable=========")
    for k,v in pairs(rcTable) do

        print(k,v)
    end
    --删除网格表的记录
    for i,v in ipairs(rcTable) do
        local gridType=block.GridType[i]
        local r=v.r
        local c=v.c

        print("r=====",r)
        print("c=====",c)

        local gridInfo=RoadGridTable[r][c]

        if gridType~=GridTypeEnum.Full_Lattice and tableNums(gridInfo.GridSprite)>1 then
            --todo
            local separateType= DirectorUtils.getFullBlockSeparate(gridType)
            gridInfo.GridType=separateType
            
            local key = 0
            for i,v in ipairs(gridInfo.GridSprite) do
                if v==block then
                    --todo
                    key=i
                    print("v==blockv==blockv==blockv==block")
                    -- RoadGridTable[r][c].GridSprite[i]=nil
                end
            end

            -- print("···")
            table.remove(RoadGridTable[r][c].GridSprite,key)

            -- if key==1 then
            --     gridInfo.GridSprite[2]=gridInfo.GridSprite[2]
            --     gridInfo.GridSprite[2]=nil
            -- end

        else
            print("RoadGridTable[r][c]=nil")
            RoadGridTable[r][c]=nil
        end

        print(i,v)
    end

end 

function DirectorUtils.getRoadGridSprite(GridSprite)
    for k,v in pairsByKeys(GridSprite) do
        return k,v
    end
end    

function DirectorUtils.blockRCTableEqual(rcTable1,rcTable2)

    if tableNums(rcTable1)~=tableNums(rcTable2) then
        --todor
        return false
    end

    for i,v in ipairs(rcTable1) do
        if v.r~=rcTable2[i].r or v.c~=rcTable2[i].c then
            --todo
            return false
        end
    end

    return true
end   

function DirectorUtils.removeRoadGridSprite(block)
    
    print("removeRoadGridSpriteremoveRoadGridSprite")
    -- local rcTable=block.rc
    --     --删除网格表的记录
    -- for i,v in ipairs(rcTable) do
    --     local gridType=block.GridType[i]
    --     local r=v.r
    --     local c=v.c

    --     print("removeGameBlock r====",r)
    --     print("removeGameBlock c====",c)
        
    --     if gridType~=GridTypeEnum.Full_Lattice and tableNums(rcTable)>1 then
    --         --todo
    --         local separateType= DirectorUtils.getFullBlockSeparate(gridType)
    --         RoadGridTable[r][c]={GridType=separateType}

    --         --格子没有精灵为空
    --         local index=1
    --         if RoadGridTable[r][c].GridSprite then
    --             --todo
    --             for i,v in ipairs(RoadGridTable[r][c].GridSprite) do
    --                 if v==block then
    --                     --todo
    --                     index=i
    --                 end
    --             end

    --             table.remove(RoadGridTable[r][c].GridSprite,index)
    --         else
    --             RoadGridTable[r][c]=nil    
    --         end

    --     else
    --         RoadGridTable[r][c]=nil
    --     end

    --     print(i,v)
    -- end
    
    DirectorUtils.removeFormRoadGrid(block)
    List.removeObj(RoadBlockTable,block)
    block:removeFromParent();
end 

-- function DirectorUtils.getGridBlockInfo(block)

--     if block then
--         local blockInfo={}

--         blockInfo.

--     end

--     return nil

-- end

function DirectorUtils.upGridIsNull(row,col)
    -- body
    if RoadGridTable[row] then
        --todo
        if RoadGridTable[row][col] then
            --todo
            print("RoadGridTable[row][col]=====",RoadGridTable[row][col])
            return false
        end
    end

    return true
end

function DirectorUtils.isCanbothPartieForGrid(curRow,row,col)
    print("isCanbothPartieForGridisCanbothPartieForGrid")
    print("row========",row)
    print("col========",col)
    print("curRow=======",curRow)
    -- body
    if DirectorUtils.upGridIsNull(row,col)==true then
        --todo
        return false
    end

    if tableNums(RoadGridTable[row][col].GridSprite)>0 then

        -- print("row========",row)
        -- print("col========",col)
        -- print("curRow=======",curRow)
        print("tableNums(RoadGridTable[row][col].GridSprite)>0")
        print("RoadGridTable[row][col].GridType====",RoadGridTable[row][col].GridType)
        if RoadGridTable[row][col].GridType==GridTypeEnum.Full_Lattice then
            return true     
        elseif (curRow>row and (RoadGridTable[row][col].GridType==GridTypeEnum.Semi_Lattice_Right_Down 
            or RoadGridTable[row][col].GridType==GridTypeEnum.Semi_Lattice_Right_Up))then
            return true
        elseif (curRow<row and (RoadGridTable[row][col].GridType==GridTypeEnum.Semi_Lattice_Left_Up 
            or RoadGridTable[row][col].GridType==GridTypeEnum.Semi_Lattice_Left_Down)) then    
            return true
        end    
    end    

    return false
end

--地形不能吃
function DirectorUtils.isEatCommonBlockForGrid(row,col)
    -- body
    if DirectorUtils.upGridIsNull(row,col)==true then
        --todo
        return false
    end

    if tableNums(RoadGridTable[row][col].GridSprite)>0 then
        local  isEat = true
        for k,v in pairs(RoadGridTable[row][col].GridSprite) do
            if v.BlockMassType<=BlockMassTypeEnum.Block_Stone_Mass then
                --todo
                isEat=false
            end
        end

        return isEat     
    end

    return false
end

--石头以下能吃
function DirectorUtils.isEatStoneBlockForGrid(row,col)
    -- body
    if DirectorUtils.upGridIsNull(row,col)==true then
        --todo
        return false
    end

    if tableNums(RoadGridTable[row][col].GridSprite)>0 then
        local  isEat = true
        for k,v in pairs(RoadGridTable[row][col].GridSprite) do
            if v.BlockMassType>BlockMassTypeEnum.Block_Stone_Mass then
                --todo
                isEat=false
            end
        end

        return isEat     
    end

    return false
end

-- BlockMoveEffectTypeEnum={
--     --第一种移动效果
--     Block_Move_Not_Effect = 1,         
--     --第二种移动效果
--     Block_Move_Effect2 = 2, 
--     --第三种移动效果     
--     Block_Move_Effect3 = 3,   
--     --第二种移动效果和第一种效果
--     Block_Move_Effect2_Effect1 = 4, 
--     --第三种移动效果和第一种效果     
--     Block_Move_Effect3_Effect1 = 5,  

-- }

    -- --云
    -- Block_Cloud_Mass = 1,         
    -- --萤火虫
    -- Block_Firefly_Mass = 2, 
    -- --蘑菇       
    -- Block_Mogu_Mass = 3,   
    -- --草
    -- Block_Brushwood_Mass = 4,
    -- --木板
    -- Block_Board_Mass = 5,      
    -- --石块
    -- Block_Stone_Mass=6,

-- TouchEndMove
function DirectorUtils.getBlockMoveEffectType(block,moveRCTable)

    local maxC=9
    for k,v in pairs(block.rc) do
        if v.c>maxC then
            --todo
            maxC=v.c
        end
    end

    local minC=1

    for k1,v1 in pairs(moveRCTable) do
        if v1.c>minC then
            --todo
            minC=v1.c
        end
    end
    print("getBlockMoveEffectType  maxCmaxCmaxC==",maxC)
    print("getBlockMoveEffectType  minCminCminC==",minC)

    --没有下落音效有动作
    if maxC-minC>0 and maxC-minC<=2 then
        --todo
        if block.BlockMassType>BlockMassTypeEnum.Block_Mogu_Mass then
            --todo
            return BlockMoveEffectTypeEnum.Block_Move_Effect3
        else
            return BlockMoveEffectTypeEnum.Block_Move_Effect2    
        end
    --有下落音效和动作    t
    elseif maxC-minC>2 then
            --todo    
        if block.BlockMassType>BlockMassTypeEnum.Block_Mogu_Mass then
            --todo
            return BlockMoveEffectTypeEnum.Block_Move_Effect3_Effect1
        else
            return BlockMoveEffectTypeEnum.Block_Move_Effect2_Effect1    
        end    
    end

    return BlockMoveEffectTypeEnum.Block_Move_Not_Effect
end    

--运动中效果
function DirectorUtils.BlockMoveEffectType(block,Effect_type)

end  

--运动结束之后效果
function DirectorUtils.BlockMoveEndEffectType(block,Effect_type)


    --方块小于一定重量的下落
    if Effect_type==BlockMoveEffectTypeEnum.Block_Move_Effect2_Effect1
    or Effect_type==BlockMoveEffectTypeEnum.Block_Move_Effect3 then
        --todo
        -- print("Effect_type==BlockMoveEffectTypeEnum.Block_Move_Effect3_Effect1")
        -- local roteAction1=cc.RotateBy:create(0.1,15)
        -- local roteAction2=cc.RotateBy:create(0.1,-30)
        -- local roteAction3=cc.RotateBy:create(0.1,25)
        -- local roteAction4=cc.RotateBy:create(0.1,-20)
        -- local roteAction5=cc.RotateBy:create(0.1,15)
        -- local roteAction6=cc.RotateBy:create(0.1,-10)
        -- local roteAction7=cc.RotateBy:create(0.1,5)

        -- local pve=transition.sequence({roteAction1,roteAction2,roteAction3,roteAction4,roteAction5,roteAction6,roteAction7})
        -- transition.execute(block,pve,{
        --         onComplete=function()

        --         end 
        --     })

        MusicManager.playSound(EnumMusicType.drop_medium)

    elseif Effect_type==BlockMoveEffectTypeEnum.Block_Move_Effect3_Effect1 
        or Effect_type==BlockMoveEffectTypeEnum.Block_Move_Effect2 then
            --todo    
        local sprite = cc.Sprite:create("block_luoxia_1.png")
        local tempAnimate = GameAU.GameBlockAnimate("block_luoxia_%d.png",10,0.05,false,false)
        local sequence=cc.Sequence:create(tempAnimate, cc.RemoveSelf:create())
        local spritePos=DirectorUtils.getBlockBottomPoint(block)

        sprite:setPosition(cc.p(spritePos.x,spritePos.y+20))
        
        print("spritePos=====",spritePos.x,spritePos.y)


        playerBlock:addChild(sprite,LayerZOrderEnum.BoomAppleZOrder)
        -- block:addChild(sprite)
        transition.execute(sprite,sequence,{
                onComplete=function()

                end 
            })

        --屏幕震动
        print("SGGShakeSGGShakeSGGShake")
        local shakeAction=SGGShake:create(0.10,4);
        transition.execute(gameScene,shakeAction,{
            onComplete=function()
                print("SGGShakeSGGShakeSGGShakeendend end")
                gameScene:setPosition(cc.p(0,0))
            end 
        })

        MusicManager.playSound(EnumMusicType.drop_heavy)
    end

    block.BlockMoveEffect=BlockMoveEffectTypeEnum.Block_Move_Not_Effect
end    

function isHaveWater(layer)
    local curscene=cc.UserDefault:getInstance():getIntegerForKey("curScene", 1)
    if curscene==2 then
        -- Blockbegin=5,Blockend=7,scalex=3,scaley=1,
        local data=returnWaterData(gameMainControlLevel)
        local point = cc.p((data.Blockbegin-1)*80+27+data.scalex/2*80,40)
        print("isHaveWater(layer)",data.Blockbegin)
        print("isHaveWater(layer)",point)
        local water=require("SggWaterNode").create(point,data.scalex,data.scaley)
        layer:addChild(water,-2,LayerTagEnum.WaterTag)
        
    end
end

-- function DirectorUtils.blockFirstDownEffect(block)
--     --处理镜面效果
--     if self.isFirstDown==true then
--         self.isFirstDown=false
--         if GamePulleyUtils:disposalMirror()~=false then
--             GamePulleyUtils:generateMirrorBlock(self)
--         else
            
--         end  
--     end
-- end    


--小女孩换装加载图片和资源
function DirectorUtils.addPlayerCache( type )
    if type==GamePlayerTypeEnum.Game_Player_Type_1 then
        ccs.ArmatureDataManager:getInstance():addArmatureFileInfo("No00.png","No00.plist" , "No00.ExportJson");
    elseif type==GamePlayerTypeEnum.Game_Player_Type_2 then
        ccs.ArmatureDataManager:getInstance():addArmatureFileInfo("No1.png","No1.plist" , "No1.ExportJson");  
    elseif type==GamePlayerTypeEnum.Game_Player_Type_3 then
        ccs.ArmatureDataManager:getInstance():addArmatureFileInfo("No333333.png","No333333.plist" , "No333333.ExportJson");       
    elseif type==GamePlayerTypeEnum.Game_Player_Type_4 then
        ccs.ArmatureDataManager:getInstance():addArmatureFileInfo("No2.png","No2.plist" , "No2.ExportJson");
    elseif type==GamePlayerTypeEnum.Game_Player_Type_5 then
        ccs.ArmatureDataManager:getInstance():addArmatureFileInfo("No3.png","No3.plist" , "No3.ExportJson");
    elseif type==GamePlayerTypeEnum.Game_Player_Type_6 then  
        ccs.ArmatureDataManager:getInstance():addArmatureFileInfo("No4.png","No4.plist" , "No4.ExportJson");
    elseif type==GamePlayerTypeEnum.Game_Player_Type_7 then  
        ccs.ArmatureDataManager:getInstance():addArmatureFileInfo("No5.png","No5.plist" , "No5.ExportJson");
    elseif type==GamePlayerTypeEnum.Game_Player_Type_8 then  
        ccs.ArmatureDataManager:getInstance():addArmatureFileInfo("No6.png","No6.plist" , "No6.ExportJson");
    elseif type==GamePlayerTypeEnum.Game_Player_Type_Spec then  
        ccs.ArmatureDataManager:getInstance():addArmatureFileInfo("No7.png","No7.plist" , "No7.ExportJson");
         
    end
     
end

--小女孩删除图片和资源缓存
function DirectorUtils.removePlayerCache( type )
    if type==GamePlayerTypeEnum.Game_Player_Type_1 then
        ccs.ArmatureDataManager:getInstance():removeArmatureFileInfo("No00.ExportJson");
    elseif type==GamePlayerTypeEnum.Game_Player_Type_2 then
        ccs.ArmatureDataManager:getInstance():removeArmatureFileInfo("No1.ExportJson");    
    elseif type==GamePlayerTypeEnum.Game_Player_Type_3 then
        ccs.ArmatureDataManager:getInstance():removeArmatureFileInfo("No333333.ExportJson");    
    elseif type==GamePlayerTypeEnum.Game_Player_Type_4 then
        ccs.ArmatureDataManager:getInstance():removeArmatureFileInfo("No2.ExportJson");
    elseif type==GamePlayerTypeEnum.Game_Player_Type_5 then
        ccs.ArmatureDataManager:getInstance():removeArmatureFileInfo("No3.ExportJson");
    elseif type==GamePlayerTypeEnum.Game_Player_Type_6 then  
        ccs.ArmatureDataManager:getInstance():removeArmatureFileInfo("No4.ExportJson");
    elseif type==GamePlayerTypeEnum.Game_Player_Type_7 then  
        ccs.ArmatureDataManager:getInstance():removeArmatureFileInfo("No5.ExportJson"); 

    elseif type==GamePlayerTypeEnum.Game_Player_Type_8 then  
        ccs.ArmatureDataManager:getInstance():removeArmatureFileInfo("No6.ExportJson"); 
    elseif type==GamePlayerTypeEnum.Game_Player_Type_Spec then  
        ccs.ArmatureDataManager:getInstance():removeArmatureFileInfo("No7.ExportJson"); 
         

    end
end


function darkNode(node)


    local vertDefaultSource = "\n"..
        "attribute vec4 a_position; \n" ..
        "attribute vec2 a_texCoord; \n" ..
        "attribute vec4 a_color; \n"..                                                    
        "#ifdef GL_ES  \n"..
        "varying lowp vec4 v_fragmentColor;\n"..
        "varying mediump vec2 v_texCoord;\n"..
        "#else                      \n" ..
        "varying vec4 v_fragmentColor; \n" ..
        "varying vec2 v_texCoord;  \n"..
        "#endif    \n"..
        "void main() \n"..
        "{\n" ..
        "gl_Position = CC_PMatrix * a_position; \n"..
        "v_fragmentColor = a_color;\n"..
        "v_texCoord = a_texCoord;\n"..
        "}"

    local pszFragSource = "#ifdef GL_ES \n" ..
        "precision mediump float; \n" ..
        "#endif \n" ..
        "varying vec4 v_fragmentColor; \n" ..
        "varying vec2 v_texCoord; \n" ..
        "void main(void) \n" ..
        "{ \n" ..
        "vec4 c = texture2D(CC_Texture0, v_texCoord); \n" ..
        "gl_FragColor.xyz = vec3(0.4*c.r + 0.4*c.g +0.4*c.b); \n"..
        "gl_FragColor.w = c.w; \n"..
        "}"

    local pProgram = cc.GLProgram:createWithByteArrays(vertDefaultSource,pszFragSource)

    pProgram:bindAttribLocation(cc.ATTRIBUTE_NAME_POSITION,cc.VERTEX_ATTRIB_POSITION)
    pProgram:bindAttribLocation(cc.ATTRIBUTE_NAME_COLOR,cc.VERTEX_ATTRIB_COLOR)
    pProgram:bindAttribLocation(cc.ATTRIBUTE_NAME_TEX_COORD,cc.VERTEX_ATTRIB_FLAG_TEX_COORDS)
    pProgram:link()
    pProgram:updateUniforms()
    node:setGLProgram(pProgram)

end

function BlueNode(node)


    local vertDefaultSource = "\n"..
        "attribute vec4 a_position; \n" ..
        "attribute vec2 a_texCoord; \n" ..
        "attribute vec4 a_color; \n"..                                                    
        "#ifdef GL_ES  \n"..
        "varying lowp vec4 v_fragmentColor;\n"..
        "varying mediump vec2 v_texCoord;\n"..
        "#else                      \n" ..
        "varying vec4 v_fragmentColor; \n" ..
        "varying vec2 v_texCoord;  \n"..
        "#endif    \n"..
        "void main() \n"..
        "{\n" ..
        "gl_Position = CC_PMatrix * a_position; \n"..
        "v_fragmentColor = a_color;\n"..
        "v_texCoord = a_texCoord;\n"..
        "}"

    local pszFragSource = "#ifdef GL_ES \n" ..
        "precision mediump float; \n" ..
        "#endif \n" ..
        "varying vec4 v_fragmentColor; \n" ..
        "varying vec2 v_texCoord; \n" ..
        "void main(void) \n" ..
        "{ \n" ..
        "vec4 c = texture2D(CC_Texture0, v_texCoord); \n" ..
        "gl_FragColor.xyz = vec3(0.001*c.r,0.001*c.g,3*c.b); \n"..
        "gl_FragColor.w = c.w; \n"..
        "}"

    local pProgram = cc.GLProgram:createWithByteArrays(vertDefaultSource,pszFragSource)

    pProgram:bindAttribLocation(cc.ATTRIBUTE_NAME_POSITION,cc.VERTEX_ATTRIB_POSITION)
    pProgram:bindAttribLocation(cc.ATTRIBUTE_NAME_COLOR,cc.VERTEX_ATTRIB_COLOR)
    pProgram:bindAttribLocation(cc.ATTRIBUTE_NAME_TEX_COORD,cc.VERTEX_ATTRIB_FLAG_TEX_COORDS)
    pProgram:link()
    pProgram:updateUniforms()
    node:setGLProgram(pProgram)
end

function NormalNode(node)


    local vertDefaultSource = "\n"..
        "attribute vec4 a_position; \n" ..
        "attribute vec2 a_texCoord; \n" ..
        "attribute vec4 a_color; \n"..                                                    
        "#ifdef GL_ES  \n"..
        "varying lowp vec4 v_fragmentColor;\n"..
        "varying mediump vec2 v_texCoord;\n"..
        "#else                      \n" ..
        "varying vec4 v_fragmentColor; \n" ..
        "varying vec2 v_texCoord;  \n"..
        "#endif    \n"..
        "void main() \n"..
        "{\n" ..
        "gl_Position = CC_PMatrix * a_position; \n"..
        "v_fragmentColor = a_color;\n"..
        "v_texCoord = a_texCoord;\n"..
        "}"

    local pszFragSource = "#ifdef GL_ES \n" ..
        "precision mediump float; \n" ..
        "#endif \n" ..
        "varying vec4 v_fragmentColor; \n" ..
        "varying vec2 v_texCoord; \n" ..
        "void main(void) \n" ..
        "{ \n" ..
        --"vec4 c = texture2D(CC_Texture0, v_texCoord); \n" ..
        --"gl_FragColor.xyz = vec3(c.r + c.g +c.b); \n"..
        --"gl_FragColor.w = c.w; \n"..


        "gl_FragColor = v_fragmentColor * texture2D(CC_Texture0, v_texCoord);\n"..




        "}"

    local pProgram = cc.GLProgram:createWithByteArrays(vertDefaultSource,pszFragSource)

    --pProgram:bindAttribLocation(cc.ATTRIBUTE_NAME_POSITION,cc.VERTEX_ATTRIB_POSITION)
    --pProgram:bindAttribLocation(cc.ATTRIBUTE_NAME_COLOR,cc.VERTEX_ATTRIB_COLOR)
    --pProgram:bindAttribLocation(cc.ATTRIBUTE_NAME_TEX_COORD,cc.VERTEX_ATTRIB_FLAG_TEX_COORDS)
    pProgram:link()
    pProgram:updateUniforms()
    node:setGLProgram(pProgram)
end


function yaohuangSprite(sprite)
    print("yaohuang========")
    -- if sprite:getNumberOfRunningActions()~=0 then
    --     return
    -- end
   
    if sprite.action then

    else
        sprite:stopAllActions()
        print("11111111111111111")
        print("spritename",sprite:getName())
        local scaleY=sprite:getScaleY()
        print("scalex====",sprite:getScaleX())
        print("scaley====",sprite:getScaleY())
        sprite.action=true
        local oldpoint = sprite:getPosition();


        sprite:setAnchorPoint(cc.p(0.5, 0));
        sprite:setPositionY(sprite:getPositionY()-sprite:getContentSize().height / 2*scaleY);
        local Rota_1 = cc.RotateBy:create(0.1, 5);
        local Rota_2 = cc.RotateBy:create(0.2, -10);
        local Rota_3 = cc.RotateBy:create(0.1, 5);
        local function callback(pSender)
            sprite:setAnchorPoint(cc.p(0.5, 0.5))
            sprite:setPositionY(sprite:getPositionY() + sprite:getContentSize().height / 2*scaleY);
            sprite.action=false
        end

        local call=cc.CallFunc:create(callback)
        local seq = cc.Sequence:create(Rota_1, Rota_2, Rota_3,call)


        sprite:runAction(seq);

    end
end






